import { BasicContainer } from '/sd:basic-container.js'; 
/**
 * class to create instance of Dunamic Image. It save content text inside div container and changes Image file on state change
 */
export class DynamicImage extends BasicContainer {
	/**
	 * @param    {jQuery} xmlObject    	Data loaded from XML
	 * @param    {String} parentId    	HTML ID of the object, which has to be a parent of constructing object
	 * @param    {Integer} itemNumber   Number of object constructing item - if it is null, it means, that item is not numerable
	 * @param    {String} objId    		ID of creating object - if itemNumber is not null, then itemNumber will be suffix of the ID
	 * @param    {String} themeName    	Name of choose theme
	 */
	constructor(xmlObject, parentId, itemNumber = null, objId, themeName) {
		super(xmlObject, parentId, "DynamicImageContainer", itemNumber, objId, false, themeName);
	}
	
	/**
	 * Creates object in HTML file - adjusted to work with DynamicImage
	 * @override Method in BasicContainer
	 * @param    {NamedNodeMap} attributes   List of attributes of the HTML object loaded from XML 
	 */
	createObject(attributes) {
		this.mainObj = document.createElement("div");
		this.mainObj.setAttribute("id", this.id + "Container");
		this.parentObj.appendChild(this.mainObj);
		
		this.image = document.createElement("img");
		this.image.setAttribute("id", this.id);
		this.image.setAttribute("class", "DynamicImage");
		if(this.id.indexOf("unactive") > 0) {
			if(this.id.indexOf("statusPoint") == 0)
				var filePath = "/sd:" + this.themeName + "_off.png";
			else if(this.id.indexOf("alarmPoint") == 0)
				var filePath = "/sd:" + this.themeName + "_no_alarm.png";
		}
		else if(this.id.indexOf("activeStatus") > 0)
			var filePath = "/sd:" + this.themeName + "_on.png";
		else if(this.id.indexOf("activeAlarm") > 0)
			var filePath = "/sd:" + this.themeName + "_alarm.png";
		this.image.setAttribute("src", window.location.protocol + "//" + window.location.host + filePath);
		this.image.setAttribute("alt", "image centered");
		this.mainObj.appendChild(this.image);

		this.createThemeSchema();
		if(attributes != null)
			this.readAllStylesFromAttributes(attributes);
	}
	
	/**
	 * Changes the visibility of HTML object releated to instance of DynamicImage
	 * @param {Boolean} value 	Value of the visibility
	 */
	setVisibility(value) {
		this.image.style.setProperty("display", (value) ? "block" : "none");
	}
}